/***********************************************************************/
/** 	© 2015 CD PROJEKT S.A. All rights reserved.
/** 	THE WITCHER® is a trademark of CD PROJEKT S. A.
/** 	The Witcher game is based on the prose of Andrzej Sapkowski.
/***********************************************************************/




state camera_hack in W3PlayerWitcher extends ExtendedMovable 
{
	
	protected var camera : CCustomCamera;
	protected var fovVel : float;
	protected var initialPitch : float;
	
	private var cachedHorTimeout : float;
	private var cachedVerTimeout : float;
	
	private var prevState		 : name;
	
	var starttime				: float;
	
	var X,Y,Z 					: float;

	event OnEnterState( prevStateName : name )
	{
		prevState = prevStateName;
		super.OnEnterState(prevStateName);
		
		CreateNoSaveLock();
		
		//theInput.SetContext( 'ThrowHold' );
		//parent.lastAxisInputIsMovement = true;
		//parent.SetCombatIdleStance( 1.f );
		
		//camera = (CCustomCamera)theCamera.GetTopmostCameraObject();
		//theGame.GetGameCamera().ChangePivotDistanceController('AimThrow');
		//theGame.GetGameCamera().ChangePivotRotationController('AimThrow');
		
		//camera.EnableScreenSpaceCorrection( false );
		
		theTelemetry.LogWithName(TE_STATE_AIM_THROW);
		
		starttime = theGame.GetEngineTimeAsSeconds();
		SearchForTargets__();
		initialPitch = ProcessInitialPitch();
		
		
		
		//cachedHorTimeout = camera.GetManualRotationHorTimeout();
		//cachedVerTimeout = camera.GetManualRotationVerTimeout();
		
		//camera.SetManualRotationHorTimeout(1.0);
		//camera.SetManualRotationVerTimeout(1.0);
		
		thePlayer.BreakPheromoneEffect();
	}
	
	entry function SearchForTargets__()
	{
		var target : CActor;
		var thrownEntity		: CThrowable;
		
		target = parent.GetTarget();
		
		while( true )
		{
			if ( !theGame.GetInGameConfigWrapper().GetVarValue('magic_spells_main', 'cast_to_camera') 
				&& thePlayer.IsInCombat() && !GetMagicVigil().is_in_manual_aiming && GetMagicVigil().state_name != 'BloodMoonSpells' )
			{
				OnProcessCastingOrientationSpellsStream( true );
			}
			else
			{
				parent.AddCustomOrientationTarget( OT_CameraOffset, 'MagicSpells' );
			}
			
			if( target )
			{
				if( ((CNewNPC)( target )).IsShielded( thePlayer ) )
					((CNewNPC)( target )).OnIncomingProjectile( true );
			}
			
			Sleep( 0.1 );
		}
	}
	
	event OnLeaveState( nextStateName : name )
	{
		//parent.SetIsShootingFriendly( false );
		parent.playerAiming.StopAiming();
	
		
	
		//camera.fov = 60.f;
		
		//camera.EnableScreenSpaceCorrection( true );
		
		
		//virtual_parent.rawPlayerHeading = theCamera.GetCameraHeading();
		//virtual_parent.RemoveCustomOrientationTarget( 'AimThrow' );
		
		//thePlayer.SetBehaviorVariable( 'walkInPlace', 0.f );
		
		//camera.SetManualRotationHorTimeout(cachedHorTimeout);
		//camera.SetManualRotationVerTimeout(cachedVerTimeout);
		
		if ( nextStateName == 'PlayerDialogScene' )
		{
			virtual_parent.crossbowDontPopStateHack = true;
			parent.OnRangedForceHolster( true, true );
			virtual_parent.crossbowDontPopStateHack = false;
		}
		
		super.OnLeaveState(nextStateName);
	}
	
	private function ProcessInitialPitch() : float
	{
		var angles : EulerAngles;
		var aimingTarget	: CActor;
		var pos, playerpos : Vector;
		
		aimingTarget = (CActor)( parent.GetDisplayTarget() );
		playerpos = parent.GetWorldPosition();
		playerpos.Z += 1.8f;
		pos = MatrixGetTranslation( aimingTarget.GetBoneWorldMatrixByIndex( aimingTarget.GetTorsoBoneIndex() ) );
		pos.Z += 0.25f;
		angles = VecToRotation( pos - playerpos );
		
		return -angles.Pitch;
	}
	
	private var followTarget : bool;
	private var followPitch : float;
	var isRotating : bool;
	
	event OnGameCameraTick( out moveData : SCameraMovementData, dt : float )
	{
		var cameraOffset : float;
		var currRotation : EulerAngles;
		var angledist : float;
		var rawToCamHeadingDiff	: float;
		var camOffsetVec 	: Vector;
		var heading			: float;
		var followPosition : Vector;
		
		if ( Spells_camera_streams( X, Y, Z ) ) 
		{	
			UpdateCameraChanneledSignSpells( moveData, dt );
		}
		else if ( Spells_camera_manual_aiming( X, Y, Z ) ) 
		{	
			UpdateCameraChanneledSignSpells( moveData, dt );
		}
		
		return true;
		
		/*
		theGame.GetGameCamera().ChangePivotRotationController( 'AimThrow' );
		theGame.GetGameCamera().ChangePivotPositionController( 'Default' );
		theGame.GetGameCamera().ChangePivotDistanceController( 'AimThrow' );
		
		moveData.pivotRotationController = theGame.GetGameCamera().GetActivePivotRotationController();
		moveData.pivotDistanceController = theGame.GetGameCamera().GetActivePivotDistanceController();
		moveData.pivotPositionController = theGame.GetGameCamera().GetActivePivotPositionController();
	
		if ( GetMagicVigil().Spells_camera_streams( camOffsetVec.X, camOffsetVec.Y, camOffsetVec.Z ) ) {} // magic_spells_revamped
	
		moveData.pivotPositionController.SetDesiredPosition( virtual_parent.GetWorldPosition(), 100.f );
		moveData.pivotRotationController.SetDesiredHeading( moveData.pivotRotationValue.Yaw, 1.f );			
		
		moveData.pivotDistanceController.SetDesiredDistance( 1.f );
		moveData.pivotPositionController.offsetZ = 1.5f;
	
		moveData.pivotRotationController.SetDesiredPitch( initialPitch, 1.f );
		
		DampVectorSpring( moveData.cameraLocalSpaceOffset, moveData.cameraLocalSpaceOffsetVel, Vector( camOffsetVec.X, camOffsetVec.Y, camOffsetVec.Z ), 0.2f, dt );		
		
		
		*/
	}
	
	
	protected function UpdateCameraChanneledSignSpells( out moveData : SCameraMovementData, timeDelta : float ) : bool
	{	
		var screenSpaceOffset	: float;
		var screenSpaceOffsetFwd : float;
		var screenSpaceOffsetUp	: float;
		var heading				: float;
		var pitch				: float;
		var playerToTargetRot 	: EulerAngles;
		var rightOffset			: float = -20.f;
		var leftOffset			: float = 15.f;
		var angles				: EulerAngles;
		
		var vec					: Vector;
		
		if( ( GetMagicVigil().IsAlt() || GetMagicVigil().is_in_manual_aiming ) )
		{
			theGame.GetGameCamera().ChangePivotRotationController( 'SignChannel' );
			theGame.GetGameCamera().ChangePivotDistanceController( 'SignChannel' );
			
			moveData.pivotRotationController = theGame.GetGameCamera().GetActivePivotRotationController();
			moveData.pivotDistanceController = theGame.GetGameCamera().GetActivePivotDistanceController();
			

			if ( parent.GetCurrentlyCastSign() == ST_Axii )
				leftOffset = 32.f;

			if ( parent.oTCameraOffset != leftOffset && parent.oTCameraOffset != rightOffset  )
			{
				if( ( parent.interiorCamera && !parent.moveTarget )
					|| ( AngleDistance( parent.GetHeading(), moveData.pivotRotationValue.Yaw ) < 0 ) )
					parent.oTCameraOffset = leftOffset;				
				else
					parent.oTCameraOffset = rightOffset;
			}
			
			if ( parent.oTCameraOffset == leftOffset )
			{
				screenSpaceOffset = 0.65f + X;
				parent.oTCameraPitchOffset = 13.f; 
				
			}
			else if ( parent.oTCameraOffset == rightOffset )
			{
				screenSpaceOffset = -0.65f - X;
				parent.oTCameraPitchOffset = 13.f; 
				
			}
		
			moveData.pivotPositionController.offsetZ = 1.3f;
			
			if ( !parent.delayCameraOrientationChange )
			{
				if ( parent.GetOrientationTarget() == OT_Camera || parent.GetOrientationTarget() == OT_CameraOffset )
				{
					if ( parent.bRAxisReleased )
					{
						heading = moveData.pivotRotationValue.Yaw;
						pitch = moveData.pivotRotationValue.Pitch;
					}
					else
					{
						heading = moveData.pivotRotationValue.Yaw + parent.oTCameraOffset;
						pitch = moveData.pivotRotationValue.Pitch; 
					}
				}
				else if ( parent.GetOrientationTarget() == OT_Actor )
				{
					if ( parent.GetDisplayTarget() )
						vec = parent.GetDisplayTarget().GetWorldPosition() - parent.GetWorldPosition();
					else if ( parent.slideTarget )	
						vec = parent.slideTarget.GetWorldPosition() - parent.GetWorldPosition();
					else if ( parent.GetTarget() )
						vec = parent.GetTarget().GetWorldPosition() - parent.GetWorldPosition();
					else
						vec = parent.GetHeadingVector();
						
					angles = VecToRotation( vec );
					heading = angles.Yaw + parent.oTCameraOffset;
					pitch = -angles.Pitch - parent.oTCameraPitchOffset;
				}
				else
				{
					angles = VecToRotation( parent.GetHeadingVector() );
					heading = angles.Yaw + parent.oTCameraOffset;
					pitch = -angles.Pitch - parent.oTCameraPitchOffset;
				}
			
				if ( !parent.wasBRAxisPushed && ( !parent.bRAxisReleased ) )
					parent.wasBRAxisPushed = true;

				moveData.pivotRotationController.SetDesiredHeading( heading , 2.f );
				moveData.pivotRotationController.SetDesiredPitch( pitch );
			}
			else
			{
				moveData.pivotRotationController.SetDesiredHeading( moveData.pivotRotationValue.Yaw, 1.f );
				moveData.pivotRotationController.SetDesiredPitch( -parent.oTCameraPitchOffset );
			}
																	/*						// camera question
			if ( GetMagicVigil().is_in_manual_aiming )
			{
				screenSpaceOffsetFwd = 1.8 + Y;
				screenSpaceOffsetUp = 0.4 + Z;
			} else 													*/
			if ( moveData.pivotRotationValue.Pitch <= 5.f && moveData.pivotRotationValue.Pitch >= -15.f )
			{
				screenSpaceOffsetFwd = 1.8 + Y;
				screenSpaceOffsetUp = 0.4 + Z;
			}
			else if ( moveData.pivotRotationValue.Pitch > 0 )
			{
				screenSpaceOffsetFwd = moveData.pivotRotationValue.Pitch*0.00727 + 1.275f;
				screenSpaceOffsetFwd = ClampF( screenSpaceOffsetFwd, screenSpaceOffsetFwd - 0.3, screenSpaceOffsetFwd + 0.4 );
				
				screenSpaceOffsetUp = -moveData.pivotRotationValue.Pitch*0.00727 + 0.4363f;
				screenSpaceOffsetUp = ClampF( screenSpaceOffsetUp, screenSpaceOffsetUp - 0.4, screenSpaceOffsetUp - 0.1 );		
			}
			else	
			{
				if ( parent.GetCurrentlyCastSign() == ST_Axii )
				{
					screenSpaceOffsetFwd = -moveData.pivotRotationValue.Pitch*0.0425 + 0.8625f;		
					screenSpaceOffsetFwd = ClampF( screenSpaceOffsetFwd, screenSpaceOffsetFwd - 0.3, screenSpaceOffsetFwd + 0.5 );
				}
				else
				{
					screenSpaceOffsetFwd = -moveData.pivotRotationValue.Pitch*0.035 + 0.75f;
					screenSpaceOffsetFwd = ClampF( screenSpaceOffsetFwd, screenSpaceOffsetFwd - 0.3, screenSpaceOffsetFwd + 0.8 );
				}
				screenSpaceOffsetUp = -moveData.pivotRotationValue.Pitch*0.005 + 0.325f;
				screenSpaceOffsetUp = ClampF( screenSpaceOffsetUp, screenSpaceOffsetUp, screenSpaceOffsetUp + 0.1 );				
			}
				
			DampVectorSpring( moveData.cameraLocalSpaceOffset, moveData.cameraLocalSpaceOffsetVel, Vector( screenSpaceOffset, screenSpaceOffsetFwd, screenSpaceOffsetUp ), 0.25f, timeDelta );
			moveData.pivotDistanceController.SetDesiredDistance( 2.8f, 5.f );	
			moveData.pivotPositionController.SetDesiredPosition( parent.GetWorldPosition() );		
		
			return true;
		}
		else
		{
			parent.wasBRAxisPushed = false;
			
			return false;
		}
	}	
	
	private function GetAimPosition() : Vector
	{
		var aimVector : Vector;
		var target : CGameplayEntity;
		var angles : EulerAngles;
		
		target = parent.GetDisplayTarget();
		
		
		
		
			aimVector =  target.GetWorldPosition();
			
		angles = VecToRotation( aimVector - parent.GetWorldPosition() );
		
		followPitch = -angles.Pitch;
		
		return aimVector;
	}
	
	event OnStateCanUpdateExplorationSubstates()
	{
		return true;
	}
	
	event OnCheckDiving()
	{
		
		return prevState == 'Swimming';
	}	
	event OnIsCameraUnderwater()
	{
		return prevState == 'Swimming';
	}
	
	event OnProcessCastingOrientationSpellsStream( isContinueCasting : bool )
	{
		var customOrientationTarget : EOrientationTarget;
		var checkHeading 			: float;
		var rotHeading 				: float;
		var playerToHeadingDist 	: float;
		var slideTargetActor		: CActor;
		var newLockTarget			: CActor;
		
		var enableNoTargetOrientation	: bool;
		
		var currTime : float;
		
		enableNoTargetOrientation = true;
		if ( parent.GetDisplayTarget() && parent.IsDisplayTargetTargetable() )
		{
			enableNoTargetOrientation = false;
			if ( ( GetMagicVigil().IsAlt() || GetMagicVigil().is_in_manual_aiming ) )
			{
				if ( parent.IsPCModeEnabled() )
				{
					if ( EngineTimeToFloat( theGame.GetEngineTime() ) >  parent.pcModeChanneledSignTimeStamp + 1.f )
						enableNoTargetOrientation = true;
				}
				else
				{
					if ( GetMagicVigil().act_signtype == ST_Igni || GetMagicVigil().act_signtype == ST_Axii )
					{
						slideTargetActor = (CActor)parent.GetDisplayTarget();
						if ( slideTargetActor 
							&& ( !slideTargetActor.GetGameplayVisibility() || !parent.CanBeTargetedIfSwimming( slideTargetActor ) || !slideTargetActor.IsAlive() ) )
						{
							parent.SetSlideTarget( NULL );
							if ( parent.ProcessLockTarget() )
								slideTargetActor = (CActor)parent.slideTarget;
						}				
						
						if ( !slideTargetActor )
						{
							parent.LockToTarget( false );
							enableNoTargetOrientation = true;
						}
						else if ( parent.IsThreat( slideTargetActor ) || GetMagicVigil().act_signtype == ST_Axii )
							parent.LockToTarget( true );
						else
						{
							parent.LockToTarget( false );
							enableNoTargetOrientation = true;
						}
					}
				}
			}

			if ( !enableNoTargetOrientation )
			{			
				customOrientationTarget = OT_Actor;
			}
		}
		
		if ( enableNoTargetOrientation )
		{
			if ( parent.GetPlayerCombatStance() == PCS_AlertNear && ( GetMagicVigil().IsAlt() || GetMagicVigil().is_in_manual_aiming ) )
			{
				if ( parent.GetDisplayTarget() && !slideTargetActor )
				{
					currTime = EngineTimeToFloat( theGame.GetEngineTime() );
					if ( currTime > parent.findActorTargetTimeStamp + 1.5f )
					{
						parent.findActorTargetTimeStamp = currTime;
						
						newLockTarget = parent.GetScreenSpaceLockTarget( parent.GetDisplayTarget(), 180.f, 1.f, 0.f, true );
						
						if ( newLockTarget && parent.IsThreat( newLockTarget ) && parent.IsCombatMusicEnabled() )
						{
							parent.SetTarget( newLockTarget, true );
							parent.SetMoveTargetChangeAllowed( true );
							parent.SetMoveTarget( newLockTarget );
							parent.SetMoveTargetChangeAllowed( false );
							parent.SetSlideTarget( newLockTarget );							
						}	
					}
				}
				else
					parent.ProcessLockTarget();
			}
			
			if ( parent.wasBRAxisPushed )
				customOrientationTarget = OT_CameraOffset;
			else
			{
				if ( !parent.lastAxisInputIsMovement || theInput.LastUsedPCInput() )
					customOrientationTarget = OT_CameraOffset;
				else if ( theInput.GetActionValue( 'CastSignHold' ) > 0 )
				{
					if ( parent.GetOrientationTarget() == OT_CameraOffset )
						customOrientationTarget = OT_CameraOffset;
					else if ( parent.GetPlayerCombatStance() == PCS_AlertNear || parent.GetPlayerCombatStance() == PCS_Guarded ) 
						customOrientationTarget = OT_CameraOffset;
					else
						customOrientationTarget = OT_Player;	
				}
				else
					customOrientationTarget = OT_CustomHeading;
			}			
		}		
		
		if ( GetMagicVigil().act_signtype == ST_Quen )
		{
			if ( theInput.LastUsedPCInput() )
			{
				customOrientationTarget = OT_Camera;
			}
			else if ( ( GetMagicVigil().IsAlt() || GetMagicVigil().is_in_manual_aiming ) )
			{
				if ( parent.bLAxisReleased )
					customOrientationTarget = OT_Player;
				else
					customOrientationTarget = OT_Camera;
			}
			else 
				customOrientationTarget = OT_Player;
		}	
		
		if ( GetMagicVigil().act_signtype == ST_Axii && ( GetMagicVigil().IsAlt() || GetMagicVigil().is_in_manual_aiming ) )
		{	
			if ( parent.slideTarget && (CActor)parent.slideTarget )
			{
				checkHeading = VecHeading( parent.slideTarget.GetWorldPosition() - parent.GetWorldPosition() );
				rotHeading = checkHeading;
				playerToHeadingDist = AngleDistance( parent.GetHeading(), checkHeading );
				
				if ( playerToHeadingDist > 45 )
					parent.SetCustomRotation( 'ChanneledSignAxii', rotHeading, 0.0, 0.5, false );
				else if ( playerToHeadingDist < -45 )
					parent.SetCustomRotation( 'ChanneledSignAxii', rotHeading, 0.0, 0.5, false );					
			}
			else
			{
				checkHeading = VecHeading( theCamera.GetCameraDirection() );
				rotHeading = parent.GetHeading();
				playerToHeadingDist = AngleDistance( parent.GetHeading(), checkHeading );
				
				if ( playerToHeadingDist > 45 )
					parent.SetCustomRotation( 'ChanneledSignAxii', rotHeading - 22.5, 0.0, 0.5, false );
				else if ( playerToHeadingDist < -45 )
					parent.SetCustomRotation( 'ChanneledSignAxii', rotHeading + 22.5, 0.0, 0.5, false );				
			}
		}		
			
		if ( parent.IsActorLockedToTarget() )
			customOrientationTarget = OT_Actor;
		
		parent.AddCustomOrientationTarget( customOrientationTarget, 'Signs' );
		
		if ( customOrientationTarget == OT_CustomHeading )
			parent.SetOrientationTargetCustomHeading( parent.GetCombatActionHeading(), 'Signs' );			
	}
	
}
